// GIWIK.init.js('css');

HEADING.readData.local = function ()
{
	/* PHSUR-628: Add manual position rejection status on this page */
	if(System_state._ui_status[3]&0x80000000)
	{
		//Manual position: rejected
		window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[127].msg]));
		window.Input_ManPosStatus.setStatus(3);
		window.Input_ManPosStatus.show();
	}
	else if(System_state._ui_status[3]&0x40000000)
	{
		//Manual position: waiting
		window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[126].msg]));
		window.Input_ManPosStatus.setStatus(2);
		window.Input_ManPosStatus.show();
	}
	else if(System_state._ui_status[3]&0x20000000)
	{
		//Manual position: valide
		window.Input_ManPosStatus.setValue(MSG(['detailedstatuscodes',GIWIK._status_bits_info[125].msg]));
		window.Input_ManPosStatus.setStatus(1);
		window.Input_ManPosStatus.show();
	}
	else
	{
		window.Input_ManPosStatus.hide();
	}
};

HEADING.readConf.local = function ()
{
	if (!HEADING.init.isdone)
	{
		HEADING.heading_labels_width = 60; 	// Définit la largeur des labels des paramètres de la page
		// HEADING.heading_input_width = 140; 	// Définit la largeur des inputs des paramètres de la page
		HEADING.margin_left = (GIWIK.coordinate_mode === 1/*UTM*/) ? 108 : 90;
	
		if (GIWIK.coordinate_mode === 1/*UTM*/)
		{
			// Paramètre "Northing"
			window.Input_northing = new Input_int('Input_northing', true);
			window.Input_northing.label_width = HEADING.heading_labels_width;
			window.Input_northing.input_width= HEADING.heading_input_width;
			window.Input_northing.margin_left = HEADING.margin_left;
			window.Input_northing.construct('input_northing','linear',MSG(['parameters','utm_northing']),0.01,0,20000000,MSG(['units','meter']));
			window.Input_northing.setAction("window.ManPositionChanged=true;");
			window.Input_northing.show();

			// Paramètre "Easting"
			window.Input_easting = new Input_int('Input_easting', true);
			window.Input_easting.label_width = HEADING.heading_labels_width;
			window.Input_easting.input_width= HEADING.heading_input_width;
			window.Input_easting.margin_left = HEADING.margin_left;
			window.Input_easting.construct('input_easting','linear',MSG(['parameters','utm_easting']),0.01,0,1000000,MSG(['units','meter']));
			window.Input_easting.setAction("window.ManPositionChanged=true;");
			window.Input_easting.show();

			// Paramètre "Zone"
			window.Input_zone = new Input_text('Input_zone', true);
			window.Input_zone.label_width = HEADING.heading_labels_width;
			window.Input_zone.input_width= HEADING.heading_input_width;
			window.Input_zone.margin_left = HEADING.margin_left;
			window.Input_zone.construct('input_zone','linear',MSG(['parameters','utm_zone']),"");
			window.Input_zone.setAction("window.ManPositionChanged = true;");
			window.Input_zone.show();

		}
		else
		{
			// Paramètre "Latitude"
			window.Input_latitude = new Input_latlong('Input_latitude', true);
			window.Input_latitude.label_width = HEADING.heading_labels_width;
			window.Input_latitude.margin_left = HEADING.margin_left;
			window.Input_latitude.construct('input_latitude', MSG(['parameters','latitude']), Math.pow(10,-6), 'latitude');
			window.Input_latitude.setAction("window.ManPositionChanged=true;");//,true);
			window.Input_latitude.show();

			// Paramètre "Longitude"
			window.Input_longitude = new Input_latlong('Input_longitude', true);
			window.Input_longitude.label_width = HEADING.heading_labels_width;
			window.Input_longitude.margin_left = HEADING.margin_left;
			window.Input_longitude.construct('input_longitude', MSG(['parameters','longitude']), Math.pow(10,-6), 'longitude');
			window.Input_longitude.setAction("window.ManPositionChanged=true;");
			window.Input_longitude.show();
		}

		if (GIWIK.alti_depth)
		{
			// Paramètre "Depth / Altitude"
			window['Input_'+GIWIK.alti_depth] = new Input_int('Input_'+GIWIK.alti_depth, true);
			window['Input_'+GIWIK.alti_depth].label_width = HEADING.heading_labels_width;
			window['Input_'+GIWIK.alti_depth].input_width = HEADING.heading_input_width;
			window['Input_'+GIWIK.alti_depth].margin_left = HEADING.margin_left;
			window['Input_'+GIWIK.alti_depth].construct('input_'+GIWIK.alti_depth,'linear',MSG(['parameters',GIWIK.alti_depth]),0.01,(GIWIK.alti_depth=="depth" ? -GIWIK._max_alt[1] : GIWIK._max_alt[0]),(GIWIK.alti_depth=="depth" ? -GIWIK._max_alt[0] : GIWIK._max_alt[1]),MSG(['units','meter']));
			window['Input_'+GIWIK.alti_depth].show();
		}

		window.Input_ManPosStatus = new User_msg('Input_ManPosStatus', false);
		window.Input_ManPosStatus.margin = "10px 0 5px 0";
		window.Input_ManPosStatus.construct('input_manposstatus', 0, "");
		window.Input_ManPosStatus.hide();
	}

	if (GIWIK.coordinate_mode === 1/*UTM*/)
	{
		window.Input_northing.setValue(System_state.MANPOSUTM[0]);
		window.Input_easting.setValue(System_state.MANPOSUTM[1]);
		window.Input_zone.setValue(System_state.MANPOSUTM[3]);
	}
	else
	{
		window.Input_latitude.setValue(System_state.MANPOS[0]);
		window.Input_longitude.setValue(System_state.MANPOS[1]);
	}

	if (GIWIK.alti_depth)
	{
		window['Input_'+GIWIK.alti_depth].setValue(GIWIK.alti_depth_sign*System_state.MANPOS[2]);
	}
};

HEADING.getConf.local = function ()
{
	var _params = {};

	_params['MANPOS'] = "";
	_params['MANPOSUTM'] = "";

	return _params;
};

HEADING.sendConf.local = function ()
{
	var _params = {},
		depth = (GIWIK.alti_depth != false) ? GIWIK.alti_depth_sign*window['Input_'+GIWIK.alti_depth].getValue() : "";

	// Only send position if real change (not label rename / delete)
	if (GIWIK.coordinate_mode === 1/*UTM*/)
	{
		_params['MANPOSUTM'] =
			  window.Input_northing.getValue() + ","
			+ window.Input_easting.getValue() + ","
			+ depth + ","
			+ window.Input_zone.getValue();
	}
	else
	{
		_params['MANPOS'] =
			  window.Input_latitude.getValue() + ","
			+ window.Input_longitude.getValue() + ","
			+ depth;
	}
	return _params;
};

HEADING.construct.local = function ()
{
	var restart_after_sendconf = true;
	
	// Disable "Save to PROM" automatic command
	GIWIK.save_to_prom_needed = true;

	var cnt = '';
	
	cnt = '<div id="params_initial_position">'
			+'<div id="usermsg_restart"></div>'
			+'<div id="input_manualdata_update"></div>'
			+'<div id="input_manposstatus"></div>'
			+'<div id="input_latitude"></div>'
			+'<div id="input_longitude"></div>'
			+'<div id="input_northing"></div>'
			+'<div id="input_easting"></div>'
			+'<div id="input_'+GIWIK.alti_depth+'"></div>'
			+'<div id="input_zone"></div>'
		+'</div>';

	$('#content').append(GIWIK.box(cnt, MSG(['box','initialposition_title']), true, [], ['', 'box_content_nopaddingtop']));
	
	// Construction du message d'avertissement invitant à redémarer le système après avoir changé la position initiale
	if (restart_after_sendconf === true)
	{
		// Comportement par défaut
		var msg = MSG(['box','usermsg_restart']);
		var button_label = MSG(['buttons','restart']);
		var button_action = GIWIK.getRestartAction(function () {window.Usermsg_restart.hide();});
		var button_show = true;

		// Action sur le bouton send de la page
		var send_action = "window.Usermsg_restart.show();";

		window.Usermsg_restart = new User_msg('Usermsg_restart', true);
		window.Usermsg_restart.margin = '10px 0 10px 0';
		window.Usermsg_restart.construct('usermsg_restart', 2, msg, '<div id="restart"></div>');
		window.Usermsg_restart.hide();

		window.Restart = new Button('Restart', true);
		window.Restart.construct('restart',button_label,'default',2);
		window.Restart.setAction(button_action);
		window.Restart.disable();
		if (button_show){window.Restart.show();}
		else{window.Restart.hide();}
	}

	return {
		validation_buttons : {
			send   : {action : (send_action) ? send_action : ""}
		}
	};
};